/*
 * Decompiled with CFR 0.152.
 */
package std;

import java.util.HashMap;
import java.util.Map;

public final class StdStats {
    private StdStats() {
    }

    public static double max(double[] a) {
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < a.length; ++i) {
            if (!(a[i] > max)) continue;
            max = a[i];
        }
        return max;
    }

    public static double max(double[] a, int lo, int hi) {
        if (lo < 0 || hi >= a.length || lo > hi) {
            throw new RuntimeException("Subarray indices out of bounds");
        }
        double max = Double.NEGATIVE_INFINITY;
        for (int i = lo; i <= hi; ++i) {
            if (!(a[i] > max)) continue;
            max = a[i];
        }
        return max;
    }

    public static int max(int[] a) {
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] <= max) continue;
            max = a[i];
        }
        return max;
    }

    public static double min(double[] a) {
        double min = Double.POSITIVE_INFINITY;
        for (int i = 0; i < a.length; ++i) {
            if (!(a[i] < min)) continue;
            min = a[i];
        }
        return min;
    }

    public static double min(double[] a, int lo, int hi) {
        if (lo < 0 || hi >= a.length || lo > hi) {
            throw new RuntimeException("Subarray indices out of bounds");
        }
        double min = Double.POSITIVE_INFINITY;
        for (int i = lo; i <= hi; ++i) {
            if (!(a[i] < min)) continue;
            min = a[i];
        }
        return min;
    }

    public static int min(int[] a) {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] >= min) continue;
            min = a[i];
        }
        return min;
    }

    public static double mean(double[] a) {
        if (a.length == 0) {
            return Double.NaN;
        }
        double sum = StdStats.sum(a);
        return sum / (double)a.length;
    }

    public static double mean(double[] a, int lo, int hi) {
        int length = hi - lo + 1;
        if (lo < 0 || hi >= a.length || lo > hi) {
            throw new RuntimeException("Subarray indices out of bounds");
        }
        if (length == 0) {
            return Double.NaN;
        }
        double sum = StdStats.sum(a, lo, hi);
        return sum / (double)length;
    }

    public static double mean(int[] a) {
        if (a.length == 0) {
            return Double.NaN;
        }
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            sum += (double)a[i];
        }
        return sum / (double)a.length;
    }

    public static double var(double[] a) {
        if (a.length == 0) {
            return Double.NaN;
        }
        double avg = StdStats.mean(a);
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            sum += (a[i] - avg) * (a[i] - avg);
        }
        return sum / (double)(a.length - 1);
    }

    public static double var(double[] a, int lo, int hi) {
        int length = hi - lo + 1;
        if (lo < 0 || hi >= a.length || lo > hi) {
            throw new RuntimeException("Subarray indices out of bounds");
        }
        if (length == 0) {
            return Double.NaN;
        }
        double avg = StdStats.mean(a, lo, hi);
        double sum = 0.0;
        for (int i = lo; i <= hi; ++i) {
            sum += (a[i] - avg) * (a[i] - avg);
        }
        return sum / (double)(length - 1);
    }

    public static double var(int[] a) {
        if (a.length == 0) {
            return Double.NaN;
        }
        double avg = StdStats.mean(a);
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            sum += ((double)a[i] - avg) * ((double)a[i] - avg);
        }
        return sum / (double)(a.length - 1);
    }

    public static double varp(double[] a) {
        if (a.length == 0) {
            return Double.NaN;
        }
        double avg = StdStats.mean(a);
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            sum += (a[i] - avg) * (a[i] - avg);
        }
        return sum / (double)a.length;
    }

    public static double varp(double[] a, int lo, int hi) {
        int length = hi - lo + 1;
        if (lo < 0 || hi >= a.length || lo > hi) {
            throw new RuntimeException("Subarray indices out of bounds");
        }
        if (length == 0) {
            return Double.NaN;
        }
        double avg = StdStats.mean(a, lo, hi);
        double sum = 0.0;
        for (int i = lo; i <= hi; ++i) {
            sum += (a[i] - avg) * (a[i] - avg);
        }
        return sum / (double)length;
    }

    public static double stddev(double[] a) {
        return Math.sqrt(StdStats.var(a));
    }

    public static double stddev(double[] a, int lo, int hi) {
        return Math.sqrt(StdStats.var(a, lo, hi));
    }

    public static double stddev(int[] a) {
        return Math.sqrt(StdStats.var(a));
    }

    public static double stddevp(double[] a) {
        return Math.sqrt(StdStats.varp(a));
    }

    public static double stddevp(double[] a, int lo, int hi) {
        return Math.sqrt(StdStats.varp(a, lo, hi));
    }

    public static double sum(double[] a) {
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            sum += a[i];
        }
        return sum;
    }

    public static double sum(double[] a, int lo, int hi) {
        if (lo < 0 || hi >= a.length || lo > hi) {
            throw new RuntimeException("Subarray indices out of bounds");
        }
        double sum = 0.0;
        for (int i = lo; i <= hi; ++i) {
            sum += a[i];
        }
        return sum;
    }

    public static int sum(int[] a) {
        int sum = 0;
        for (int i = 0; i < a.length; ++i) {
            sum += a[i];
        }
        return sum;
    }

    public static int mode(int[] values) {
        HashMap<Integer, Integer> freqs = new HashMap<Integer, Integer>();
        for (int val : values) {
            Integer freq = (Integer)freqs.get(val);
            freqs.put(val, freq == null ? 1 : freq + 1);
        }
        int mode = 0;
        int maxFreq = 0;
        for (Map.Entry entry : freqs.entrySet()) {
            int freq = (Integer)entry.getValue();
            if (freq <= maxFreq) continue;
            maxFreq = freq;
            mode = (Integer)entry.getKey();
        }
        return mode;
    }
}

