/*
 * Decompiled with CFR 0.152.
 */
package aliImage;

public class Moments {
    static final int BACKGROUND = 0;

    static double moment2ndOrder(int[][] imageMatrix, int p, int q) {
        double Mpq = 0.0;
        for (int y = 0; y < imageMatrix.length; ++y) {
            for (int x = 0; x < imageMatrix[0].length; ++x) {
                if (imageMatrix[y][x] == 0) continue;
                Mpq += Math.pow(x, p) * Math.pow(y, q);
            }
        }
        return Mpq;
    }

    static double centralMoment2ndOrder(int[][] imageMatrix, int p, int q) {
        double m00 = Moments.moment2ndOrder(imageMatrix, 0, 0);
        double xCtr = Moments.moment2ndOrder(imageMatrix, 1, 0) / m00;
        double yCtr = Moments.moment2ndOrder(imageMatrix, 0, 1) / m00;
        double cMpq = 0.0;
        for (int y = 0; y < imageMatrix.length; ++y) {
            for (int x = 0; x < imageMatrix[0].length; ++x) {
                if (imageMatrix[y][x] == 0) continue;
                cMpq += Math.pow((double)x - xCtr, p) * Math.pow((double)y - yCtr, q);
            }
        }
        return cMpq;
    }

    static double normalCentralMoment2ndOrder(int[][] imageMatrix, int p, int q) {
        double m00 = Moments.moment2ndOrder(imageMatrix, 0, 0);
        double norm = Math.pow(m00, (double)(p + q + 2) / 2.0);
        return Moments.centralMoment2ndOrder(imageMatrix, p, q) / norm;
    }

    public static double orientation(int[][] imageMatrix) {
        double m11 = Moments.normalCentralMoment2ndOrder(imageMatrix, 1, 1);
        double m20 = Moments.normalCentralMoment2ndOrder(imageMatrix, 2, 0);
        double m02 = Moments.normalCentralMoment2ndOrder(imageMatrix, 0, 2);
        double angle = 0.0;
        angle = m20 == m02 ? 0.7853981633974483 : 0.5 * Math.atan(2.0 * m11 / (m20 - m02));
        return angle;
    }

    public static double eccentricity(int[][] imageMatrix) {
        double m11 = Moments.normalCentralMoment2ndOrder(imageMatrix, 1, 1);
        double m20 = Moments.normalCentralMoment2ndOrder(imageMatrix, 2, 0);
        double m02 = Moments.normalCentralMoment2ndOrder(imageMatrix, 0, 2);
        double e = ((m20 - m02) * (m20 - m02) + 4.0 * m11 * m11) / ((m20 + m02) * (m20 + m02));
        return e;
    }

    static double image_moment_p_q(int[][] image, int x, int y, int d_x, int d_y, int p, int q, int tone) {
        boolean new_i = true;
        double i_q = 1.0;
        double j_p = 1.0;
        double m_p_q = 0.0;
        for (int i = y; i < d_y; ++i) {
            for (int j = x; j < d_x; ++j) {
                int k;
                int val = image[i][j];
                if (val != tone) continue;
                if (new_i) {
                    new_i = false;
                    i_q = 1.0;
                    for (k = 0; k < q; ++k) {
                        i_q *= (double)i;
                    }
                }
                j_p = 1.0;
                for (k = 0; k < p; ++k) {
                    j_p *= (double)j;
                }
                m_p_q += j_p * i_q;
            }
            new_i = true;
        }
        return m_p_q;
    }

    static double centricmom11(int[][] image, int x, int y, int d_x, int d_y, int tone) {
        double m00 = Moments.image_moment_p_q(image, x, y, d_x, d_y, 0, 0, tone);
        double cx = Moments.image_moment_p_q(image, x, y, d_x, d_y, 1, 0, tone) / m00;
        double cy = Moments.image_moment_p_q(image, x, y, d_x, d_y, 0, 1, tone) / m00;
        double m = 0.0;
        double n = 0.0;
        for (int i = y; i < d_y; ++i) {
            for (int j = x; j < d_x; ++j) {
                if (image[i][j] != tone) continue;
                m += ((double)(-i) + cy) * ((double)j - cx);
                n += 1.0;
            }
        }
        return m / (n * n);
    }

    static double centricmom20(int[][] image, int x, int y, int d_x, int d_y, int tone) {
        double m00 = Moments.image_moment_p_q(image, x, y, d_x, d_y, 0, 0, tone);
        double cx = Moments.image_moment_p_q(image, x, y, d_x, d_y, 1, 0, tone) / m00;
        double m = 0.0;
        double n = 0.0;
        for (int i = y; i < d_y; ++i) {
            for (int j = x; j < d_x; ++j) {
                if (image[i][j] != tone) continue;
                m += ((double)j - cx) * ((double)j - cx);
                n += 1.0;
            }
        }
        return m / (n * n);
    }

    static double centricmom02(int[][] image, int x, int y, int d_x, int d_y, int tone) {
        double m00 = Moments.image_moment_p_q(image, x, y, d_x, d_y, 0, 0, tone);
        double cy = Moments.image_moment_p_q(image, x, y, d_x, d_y, 0, 1, tone) / m00;
        double m = 0.0;
        double n = 0.0;
        for (int i = y; i < d_y; ++i) {
            for (int j = x; j < d_x; ++j) {
                if (image[i][j] != tone) continue;
                m += ((double)i - cy) * ((double)i - cy);
                n += 1.0;
            }
        }
        return m / (n * n);
    }

    public static double image_eccentricity(int[][] image, int x, int y, int d_x, int d_y, int tone) {
        double m20 = Moments.centricmom20(image, x, y, d_x, d_y, tone);
        double m11 = Moments.centricmom11(image, x, y, d_x, d_y, tone);
        double m02 = Moments.centricmom02(image, x, y, d_x, d_y, tone);
        return ((m20 - m02) * (m20 - m02) + 2.0 * m11 * (2.0 * m11)) / ((m20 + m02) * (m20 + m02));
    }

    public static double findTheta(int[][] image, int x, int y, int d_x, int d_y, int tone) {
        double m20 = Moments.centricmom20(image, x, y, d_x, d_y, tone);
        double m11 = Moments.centricmom11(image, x, y, d_x, d_y, tone);
        double m02 = Moments.centricmom02(image, x, y, d_x, d_y, tone);
        if (m20 == m02) {
            System.out.println("\u00e0 man\u00e1pula");
            return 0.7853981633974483;
        }
        double cal = Math.atan(2.0 * m11 / (m20 - m02)) / 2.0;
        if (cal <= 0.7853981633974483) {
            return cal;
        }
        return 1.5707963267948966 - cal;
    }
}

