/*
 * Decompiled with CFR 0.152.
 */
package aliImage;

import aliImage.PixelCoordinate;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Contour {
    private double lenghtOfCountour;
    int label;
    protected PixelCoordinate[] pixelCoordinates;

    public Contour(int label, PixelCoordinate[] pixelCoordinates) {
        if (pixelCoordinates != null && pixelCoordinates.length != 0) {
            this.pixelCoordinates = pixelCoordinates;
        }
        this.label = label;
        this.lenghtOfCountour = this.calculateLengthOfContour();
    }

    public Contour(int label, ArrayList<PixelCoordinate> pixelCoordinateslist) {
        if (pixelCoordinateslist.size() != 0) {
            this.pixelCoordinates = new PixelCoordinate[pixelCoordinateslist.size()];
            for (int i = 0; i < pixelCoordinateslist.size(); ++i) {
                this.pixelCoordinates[i] = pixelCoordinateslist.get(i);
            }
        }
        this.label = label;
        this.lenghtOfCountour = this.calculateLengthOfContour();
    }

    public double calculateLengthOfContour() {
        if (this.pixelCoordinates.length > 2) {
            double length = 0.0;
            for (int i = 1; i < this.pixelCoordinates.length; ++i) {
                length += this.pixelCoordinates[i].distance(this.pixelCoordinates[i - 1]);
            }
            return length += this.pixelCoordinates[this.pixelCoordinates.length - 1].distance(this.pixelCoordinates[0]);
        }
        return this.pixelCoordinates.length - 1;
    }

    public double getLengthOfContour() {
        return this.lenghtOfCountour;
    }

    public int getNumberOfPixels() {
        return this.pixelCoordinates.length;
    }

    Shape makePolygon() {
        int m = this.pixelCoordinates.length;
        if (m > 1) {
            int[] xPoints = new int[m];
            int[] yPoints = new int[m];
            for (int i = 0; i < m; ++i) {
                PixelCoordinate cpt = this.pixelCoordinates[i];
                xPoints[i] = cpt.x;
                yPoints[i] = cpt.y;
            }
            return new Polygon(xPoints, yPoints, m);
        }
        PixelCoordinate cpt = this.pixelCoordinates[0];
        return new Ellipse2D.Double((double)cpt.x - 0.1, (double)cpt.y - 0.1, 0.2, 0.2);
    }

    static Shape[] makePolygons(List<Contour> contours) {
        if (contours == null) {
            return null;
        }
        Shape[] pa = new Shape[contours.size()];
        int i = 0;
        for (Contour c : contours) {
            pa[i] = c.makePolygon();
            ++i;
        }
        return pa;
    }

    void moveBy(int dx, int dy) {
        for (PixelCoordinate pt : this.pixelCoordinates) {
            pt.translate(dx, dy);
        }
    }

    static void moveContoursBy(List<Contour> contours, int dx, int dy) {
        for (Contour c : contours) {
            c.moveBy(dx, dy);
        }
    }
}

