/*
 * Decompiled with CFR 0.152.
 */
package aliImage;

import aliImage.Contour;
import aliImage.PixelCoordinate;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConnectedComponent {
    protected PixelCoordinate[] pixelCoordinates;
    protected Contour outerContour;

    public abstract ConnectedComponent newInstance(ArrayList<PixelCoordinate> var1);

    public ConnectedComponent(ArrayList<PixelCoordinate> pixelCoordinateslist) {
        if (pixelCoordinateslist != null && pixelCoordinateslist.size() != 0) {
            this.pixelCoordinates = new PixelCoordinate[pixelCoordinateslist.size()];
            for (int i = 0; i < pixelCoordinateslist.size(); ++i) {
                this.pixelCoordinates[i] = pixelCoordinateslist.get(i);
            }
        }
    }

    public boolean containPoint(int row, int col) {
        PixelCoordinate givenCoordinate = new PixelCoordinate(row, col);
        for (PixelCoordinate cor : this.pixelCoordinates) {
            if (cor != givenCoordinate) continue;
            return true;
        }
        return false;
    }

    public int getSize() {
        return this.pixelCoordinates.length;
    }

    public PixelCoordinate calculateMostLeftUp() {
        if (this.pixelCoordinates != null) {
            PixelCoordinate mostLeftUp = this.pixelCoordinates[0];
            for (PixelCoordinate cor : this.pixelCoordinates) {
                if (cor.y > mostLeftUp.y || cor.x > mostLeftUp.x) continue;
                mostLeftUp = cor;
            }
            return mostLeftUp;
        }
        return null;
    }

    public int calculateMaxWidth() {
        if (this.pixelCoordinates != null) {
            int maxCol;
            int minCol = maxCol = this.pixelCoordinates[0].x;
            for (PixelCoordinate cor : this.pixelCoordinates) {
                if (minCol >= cor.x) {
                    minCol = cor.x;
                    continue;
                }
                if (maxCol > cor.x) continue;
                maxCol = cor.x;
            }
            return maxCol - minCol;
        }
        return 0;
    }

    public int calculateMaxHigth() {
        if (this.pixelCoordinates != null) {
            int maxrow;
            int minrow = maxrow = this.pixelCoordinates[0].y;
            for (PixelCoordinate cor : this.pixelCoordinates) {
                if (minrow >= cor.y) {
                    minrow = cor.y;
                    continue;
                }
                if (maxrow > cor.y) continue;
                maxrow = cor.y;
            }
            return maxrow - minrow;
        }
        return 0;
    }

    void moveBy(int dx, int dy) {
        for (PixelCoordinate pt : this.pixelCoordinates) {
            pt.translate(dx, dy);
        }
    }

    static void moveConnectedComponentsBy(List<ConnectedComponent> connectedComponents, int dx, int dy) {
        for (ConnectedComponent c : connectedComponents) {
            c.moveBy(dx, dy);
        }
    }

    public void setOuterContour(Contour outerContour) {
        this.outerContour = outerContour;
    }

    public Contour getOuterContour() {
        return this.outerContour;
    }

    public double Perimeter() {
        return this.outerContour.getLengthOfContour();
    }

    public double Perimeter_corr() {
        return 0.95 * this.outerContour.getLengthOfContour();
    }

    public double circularity() {
        return Math.PI * 4 * ((double)this.getSize() / Math.pow(this.Perimeter_corr(), 2.0));
    }

    public double centroid_X() {
        double center_X = 0.0;
        for (PixelCoordinate cor : this.pixelCoordinates) {
            center_X += (double)cor.x;
        }
        return center_X /= (double)this.pixelCoordinates.length;
    }

    public double centroid_Y() {
        double center_Y = 0.0;
        for (PixelCoordinate cor : this.pixelCoordinates) {
            center_Y += (double)cor.y;
        }
        return center_Y /= (double)this.pixelCoordinates.length;
    }

    public double moment(int p, int q) {
        double moment = 0.0;
        for (PixelCoordinate cor : this.pixelCoordinates) {
            moment += Math.pow(cor.x, p) * Math.pow(cor.y, q);
        }
        return moment;
    }

    public double centralMoment(int p, int q) {
        double xCtr = this.centroid_X();
        double yCtr = this.centroid_Y();
        double cMpq = 0.0;
        for (PixelCoordinate cor : this.pixelCoordinates) {
            cMpq += Math.pow((double)cor.x - xCtr, p) * Math.pow(yCtr - (double)cor.y, q);
        }
        return cMpq;
    }

    public double normalizedMoment(int p, int q) {
        return this.centralMoment(p, q) * Math.pow(1.0 / this.centralMoment(0, 0), (p + q + 2) / 2);
    }

    public double orientation() {
        return Math.atan(2.0 * this.centralMoment(1, 1) / (this.centralMoment(2, 0) - this.centralMoment(0, 2))) / 2.0;
    }

    public double eccentricity() {
        double m20 = this.centralMoment(2, 0);
        double m02 = this.centralMoment(0, 2);
        double m11 = this.centralMoment(1, 1);
        double temp = Math.sqrt(Math.pow(m20 - m02, 2.0) + 4.0 * Math.pow(m11, 2.0));
        double a1 = m20 + m02 + temp;
        double a2 = m20 + m02 - temp;
        if (a1 == 0.0) {
            return 0.0;
        }
        return Math.sqrt(1.0 - a2 / a1);
    }
}

