/*
 * Decompiled with CFR 0.152.
 */
package aliImage;

import java.awt.Rectangle;
import java.awt.geom.Point2D;

public class BinaryRegion {
    int label;
    int numberOfPixels = 0;
    double xc = Double.NaN;
    double yc = Double.NaN;
    int left = Integer.MAX_VALUE;
    int right = -1;
    int top = Integer.MAX_VALUE;
    int bottom = -1;
    int x_sum = 0;
    int y_sum = 0;
    int x2_sum = 0;
    int y2_sum = 0;

    public BinaryRegion(int id) {
        this.label = id;
    }

    public int getSize() {
        return this.numberOfPixels;
    }

    public Rectangle getBoundingBox() {
        if (this.left == Integer.MAX_VALUE) {
            return null;
        }
        return new Rectangle(this.left, this.top, this.right - this.left + 1, this.bottom - this.top + 1);
    }

    public Point2D.Double getCenter() {
        if (Double.isNaN(this.xc)) {
            return null;
        }
        return new Point2D.Double(this.xc, this.yc);
    }

    public void addPixel(int x, int y) {
        ++this.numberOfPixels;
        this.x_sum += x;
        this.y_sum += y;
        this.x2_sum += x * x;
        this.y2_sum += y * y;
        if (x < this.left) {
            this.left = x;
        }
        if (y < this.top) {
            this.top = y;
        }
        if (x > this.right) {
            this.right = x;
        }
        if (y > this.bottom) {
            this.bottom = y;
        }
    }

    public void update() {
        if (this.numberOfPixels > 0) {
            this.xc = this.x_sum / this.numberOfPixels;
            this.yc = this.y_sum / this.numberOfPixels;
        }
    }
}

