/*
 * Decompiled with CFR 0.152.
 */
package aliImage;

import aliImage.ABinaryImage;
import aliImage.AColorImage;
import aliImage.arrayCopyMethod;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class AImageIO {
    public static AColorImage readColorImage(String filePathName, int bitDepth, boolean doSharping) {
        File imageFile = new File(filePathName);
        try {
            short[][][] matrix;
            BufferedImage myBufferedImage = ImageIO.read(imageFile);
            if (doSharping) {
                // empty if block
            }
            WritableRaster myRaster = myBufferedImage.getRaster();
            int height = myRaster.getHeight();
            int width = myRaster.getWidth();
            int nbands = myRaster.getNumBands();
            switch (nbands) {
                case 1: {
                    matrix = new short[nbands][height][width];
                    for (int r = 0; r < height; ++r) {
                        for (int c = 0; c < width; ++c) {
                            matrix[0][r][c] = (short)myRaster.getSample(c, r, 0);
                        }
                    }
                    break;
                }
                case 3: {
                    int nb;
                    matrix = new short[nbands][height][width];
                    for (nb = 0; nb < nbands; ++nb) {
                        for (int r = 0; r < height; ++r) {
                            for (int c = 0; c < width; ++c) {
                                matrix[nb][r][c] = (short)myRaster.getSample(c, r, nb);
                            }
                        }
                    }
                    break;
                }
                case 4: {
                    int nb;
                    matrix = new short[nbands - 1][height][width];
                    for (nb = 0; nb < nbands - 1; ++nb) {
                        int nb_plus_One = nb + 1;
                        for (int r = 0; r < height; ++r) {
                            for (int c = 0; c < width; ++c) {
                                matrix[nb][r][c] = (short)myRaster.getSample(c, r, nb_plus_One);
                            }
                        }
                    }
                    break;
                }
                default: {
                    System.err.format("unexpected number of bands: %d!!!", nbands);
                    return null;
                }
            }
            AColorImage colorImg = new AColorImage(matrix, bitDepth, arrayCopyMethod.COPY_BY_REFRENCE);
            return colorImg;
        }
        catch (IOException ex) {
            Logger.getLogger(AImageIO.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static Image convertJavaImage(AColorImage colorImage) {
        int width = colorImage.getWidth();
        int height = colorImage.getHeight();
        int numberOfBands = colorImage.getNumberOfComponents();
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        WritableRaster raster = bufferedImage.getRaster();
        for (int nb = 0; nb < numberOfBands; ++nb) {
            for (int r = 0; r < height; ++r) {
                for (int c = 0; c < width; ++c) {
                    raster.setSample(c, r, nb, colorImage.matrix[nb][r][c]);
                }
            }
        }
        return bufferedImage;
    }

    public static Image convertJavaImage(ABinaryImage binaryImage) {
        int width = binaryImage.getWidth();
        int height = binaryImage.getHeight();
        BufferedImage bufferedImage = new BufferedImage(width, height, 10);
        WritableRaster raster = bufferedImage.getRaster();
        for (int r = 0; r < height; ++r) {
            for (int c = 0; c < width; ++c) {
                if (binaryImage.matrix[r][c]) {
                    raster.setSample(c, r, 0, 255);
                    continue;
                }
                raster.setSample(c, r, 0, 0);
            }
        }
        return bufferedImage;
    }
}

