/*
 * Decompiled with CFR 0.152.
 */
package aliImage;

public class AGrayImage {
    double[][] matrix = null;
    int depth = 0;

    public AGrayImage(int nRows, int nCols, int bitDepth) {
        this.matrix = new double[nRows][nCols];
    }

    public AGrayImage(int[][] mx, int bitDepth) {
        this.depth = bitDepth;
        this.matrix = new double[mx.length][mx[0].length];
        for (int r = 0; r < mx.length; ++r) {
            for (int c = 0; c < mx[0].length; ++c) {
                this.matrix[r][c] = mx[r][c];
            }
        }
    }

    public AGrayImage(double[][] mx, int bitDepth) {
        this.depth = bitDepth;
        this.matrix = new double[mx.length][mx[0].length];
        for (int r = 0; r < mx.length; ++r) {
            System.arraycopy(mx[r], 0, this.matrix[r], 0, mx[0].length);
        }
    }

    double getMaxIntensity() {
        return Math.pow(2.0, this.depth);
    }

    double[][] getMatrix() {
        return this.matrix;
    }

    public int getwidth() {
        return this.matrix[0].length;
    }

    public int getheight() {
        return this.matrix.length;
    }

    AGrayImage getScaledMyMatrix(double scaleFactor) {
        double[][] tmpMx = new double[(int)Math.round((double)this.matrix.length * scaleFactor)][(int)Math.round((double)this.matrix[0].length * scaleFactor)];
        for (int r = 0; r < tmpMx.length; ++r) {
            for (int c = 0; c < tmpMx[0].length; ++c) {
                double u = ((double)r + 0.5) / scaleFactor - 0.5;
                double v = ((double)c + 0.5) / scaleFactor - 0.5;
                if (u < 0.0) {
                    u = 0.0;
                }
                if (v < 0.0) {
                    v = 0.0;
                }
                tmpMx[r][c] = this.bilinearInterp(u, v);
            }
        }
        return new AGrayImage(tmpMx, this.depth);
    }

    private double bilinearInterp(double u, double v) {
        int c0plus1;
        int r0 = (int)u;
        int c0 = (int)v;
        double dr = u - (double)r0;
        double dc = v - (double)c0;
        int r0plus1 = r0 + 1;
        if (r0plus1 == this.matrix.length) {
            r0plus1 = r0;
        }
        if ((c0plus1 = c0 + 1) == this.matrix.length) {
            c0plus1 = c0;
        }
        double val1 = this.matrix[r0][c0];
        double val2 = this.matrix[r0][c0plus1];
        double val3 = this.matrix[r0plus1][c0plus1];
        double val4 = this.matrix[r0plus1][c0];
        return this.linearInterp(this.linearInterp(val1, val2, dr), this.linearInterp(val3, val4, dr), dc);
    }

    private double linearInterp(double val1, double val2, double displacement) {
        return val1 * (1.0 - displacement) + val2 * displacement;
    }

    void printMatrix() {
        System.out.println("printing matrix\n");
        for (int r = 0; r < this.matrix.length; ++r) {
            for (int c = 0; c < this.matrix[0].length; ++c) {
                System.out.printf("%5.3f; ", this.matrix[r][c]);
            }
            System.out.println();
        }
    }

    private static double getRC(int r, int c, double[][] matrix, double border) {
        if (border == -1.0) {
            if (r < 0) {
                r = 0;
            }
            if (r >= matrix.length) {
                r = matrix.length - 1;
            }
            if (c < 0) {
                c = 0;
            }
            if (c >= matrix[0].length) {
                c = matrix[0].length - 1;
            }
        } else if (r < 0 || r >= matrix.length || c < 0 || c >= matrix[0].length) {
            return border;
        }
        return matrix[r][c];
    }

    public static double[][] convolve2d(double[][] kernel, double[][] matrix) {
        int uc = kernel.length / 2;
        int vc = kernel[0].length / 2;
        int height = matrix.length;
        int width = matrix[0].length;
        double[][] newMx = new double[height][width];
        double sum = 0.0;
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                sum = 0.0;
                for (int v = -vc; v <= vc; ++v) {
                    for (int u = -uc; u <= uc; ++u) {
                        sum += AGrayImage.getRC(row - v, col - u, matrix, -1.0) * kernel[v + vc][u + uc];
                    }
                }
                newMx[row][col] = sum;
            }
        }
        return newMx;
    }
}

