/*
 * Decompiled with CFR 0.152.
 */
package aliImage;

import aliImage.ABinaryImage;
import aliImage.BinaryMode;
import aliImage.ConnectedComponent;
import aliImage.ConnectivityMode;
import aliImage.Contour;
import aliImage.ContourExtractionType;
import aliImage.ContourMaker;
import aliImage.CustomComparator_forConnectedComponent;
import aliImage.PixelCoordinate;
import java.util.ArrayList;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AConnectedComponents<GenericComponentClass extends ConnectedComponent> {
    protected ArrayList<GenericComponentClass> components;
    private GenericComponentClass sampleOfComponent;
    protected ConnectivityMode connectivityMode;
    protected ContourExtractionType contourExtractionType;
    private static final int margin = 1;
    private static final byte FOREGROUND = 1;
    private static final byte BACKGROUND = 0;

    public AConnectedComponents(GenericComponentClass sampleOfComponent, ABinaryImage binaryImage, BinaryMode binaryMode, ConnectivityMode connectivityMode, ContourExtractionType contourExtractionType) {
        this.sampleOfComponent = sampleOfComponent;
        this.components = new ArrayList();
        this.connectivityMode = connectivityMode;
        this.contourExtractionType = contourExtractionType;
        int[][] pixelArray = binaryImage.getIntegerCopyOfMatrix(1);
        this.findConnectedComponentsOfImage(pixelArray);
    }

    public GenericComponentClass getComponents(int i) {
        if (i < 0 || i >= this.components.size()) {
            return null;
        }
        return (GenericComponentClass)((ConnectedComponent)this.components.get(i));
    }

    public int size() {
        return this.components.size();
    }

    public void makeEmpty() {
        this.components.clear();
    }

    public void sort() {
        Collections.sort(this.components, new CustomComparator_forConnectedComponent());
    }

    private void findConnectedComponentsOfImage(int[][] pixelArray) {
        Object c = null;
        int height = pixelArray.length;
        int width = pixelArray[0].length;
        int componentIndex = 0;
        ArrayList<PixelCoordinate> queueForProcess = new ArrayList<PixelCoordinate>();
        ArrayList<PixelCoordinate> currentComponent = new ArrayList<PixelCoordinate>();
        for (int row = 1; row < height - 1; ++row) {
            for (int col = 1; col < width - 1; ++col) {
                if (pixelArray[row][col] != 1) continue;
                ++componentIndex;
                PixelCoordinate pixelCoordinate = new PixelCoordinate(row, col);
                queueForProcess.add(pixelCoordinate);
                Contour outerContour = this.contourExtractionType == ContourExtractionType.EXTRACT_JUST_OUTER_CONTOUR ? this.traceOuterContour(pixelArray, col, row, 2) : null;
                pixelArray[row][col] = 0;
                do {
                    pixelCoordinate = (PixelCoordinate)queueForProcess.get(0);
                    currentComponent.add(pixelCoordinate);
                    queueForProcess.remove(0);
                    this.fillNeighbors(pixelArray, queueForProcess, pixelCoordinate.y, pixelCoordinate.x);
                } while (!queueForProcess.isEmpty());
                ConnectedComponent connectedComponent = ((ConnectedComponent)this.sampleOfComponent).newInstance(currentComponent);
                connectedComponent.moveBy(-1, -1);
                if (this.contourExtractionType == ContourExtractionType.EXTRACT_JUST_OUTER_CONTOUR) {
                    outerContour.moveBy(-1, -1);
                    connectedComponent.setOuterContour(outerContour);
                }
                this.components.add(connectedComponent);
                currentComponent.clear();
            }
        }
    }

    private void fillNeighbors(int[][] pixelArray, ArrayList<PixelCoordinate> queueForProcess, int row, int col) {
        int[][] delta = new int[][]{{1, 0}, {1, 1}, {0, 1}, {-1, 1}, {-1, 0}, {-1, -1}, {0, -1}, {1, -1}};
        switch (this.connectivityMode) {
            case FOUR_NEIGHBOR_CONNECTIVITY: {
                for (int i = 0; i < 8; i += 2) {
                    int y = row + delta[i][1];
                    int x = col + delta[i][0];
                    if (pixelArray[y][x] <= 0) continue;
                    PixelCoordinate pixelCoordinate = new PixelCoordinate(y, x);
                    queueForProcess.add(pixelCoordinate);
                    pixelArray[y][x] = 0;
                }
                break;
            }
            case EIGHT_NEIGHBOR_CONNECTIVITY: {
                for (int i = 0; i < 8; ++i) {
                    int y = row + delta[i][1];
                    int x = col + delta[i][0];
                    if (pixelArray[y][x] <= 0) continue;
                    PixelCoordinate pixelCoordinate = new PixelCoordinate(y, x);
                    queueForProcess.add(pixelCoordinate);
                    pixelArray[y][x] = 0;
                }
                break;
            }
        }
    }

    Contour traceOuterContour(int[][] pixelArray, int cx, int cy, int label) {
        Contour cont = this.traceContour(pixelArray, cx, cy, label, 0);
        return cont;
    }

    Contour traceContour(int[][] pixelArray, int xS, int yS, int label, int dS) {
        boolean done;
        int yT;
        int xT;
        ContourMaker contMaker = new ContourMaker();
        PixelCoordinate pt = new PixelCoordinate(yS, xS);
        int dNext = this.findNextPoint(pixelArray, pt, dS);
        contMaker.addPoint(pt);
        int xP = xS;
        int yP = yS;
        int xC = xT = pt.x;
        int yC = yT = pt.y;
        boolean bl = done = xS == xT && yS == yT;
        while (!done) {
            pixelArray[yC][xC] = label;
            pt = new PixelCoordinate(yC, xC);
            int dSearch = (dNext + 6) % 8;
            dNext = this.findNextPoint(pixelArray, pt, dSearch);
            xP = xC;
            yP = yC;
            xC = pt.x;
            yC = pt.y;
            done = xP == xS && yP == yS && xC == xT && yC == yT;
            if (done) continue;
            contMaker.addPoint(pt);
        }
        return contMaker.resolveContour(label);
    }

    int findNextPoint(int[][] pixelArray, PixelCoordinate pt, int dir) {
        int[][] delta = new int[][]{{1, 0}, {1, 1}, {0, 1}, {-1, 1}, {-1, 0}, {-1, -1}, {0, -1}, {1, -1}};
        block0 : switch (this.connectivityMode) {
            case FOUR_NEIGHBOR_CONNECTIVITY: {
                for (int i = 0; i < 7; i += 2) {
                    int y = pt.y + delta[dir][1];
                    int x = pt.x + delta[dir][0];
                    if (pixelArray[y][x] > 0) {
                        pt.x = x;
                        pt.y = y;
                        break block0;
                    }
                    pixelArray[y][x] = -1;
                    dir = (dir + 1) % 8;
                }
                break;
            }
            case EIGHT_NEIGHBOR_CONNECTIVITY: {
                for (int i = 0; i < 7; ++i) {
                    int y = pt.y + delta[dir][1];
                    int x = pt.x + delta[dir][0];
                    if (pixelArray[y][x] > 0) {
                        pt.x = x;
                        pt.y = y;
                        break block0;
                    }
                    pixelArray[y][x] = -1;
                    dir = (dir + 1) % 8;
                }
                break;
            }
        }
        return dir;
    }
}

