/*
 * Decompiled with CFR 0.152.
 */
package aliImage;

public class AColorSpaceImage {
    public double[][][] RGB2HSV(short[][][] rgbMatirx, double maxIntensity, int rowL, int rowH, int colL, int colH) {
        if (rowL < 0 || rowH >= rgbMatirx[0].length || rowL > rowH) {
            throw new RuntimeException("Row Subarray indices out of bounds");
        }
        if (colL < 0 || colH >= rgbMatirx[0].length || colL > colH) {
            throw new RuntimeException("Column Subarray indices out of bounds");
        }
        double[][][] matrix = new double[3][rgbMatirx[0].length][rgbMatirx[0][0].length];
        int height = rowH - rowL;
        int width = colH - colL;
        for (int r = 0; r < height; ++r) {
            for (int c = 0; c < width; ++c) {
                double R = (double)rgbMatirx[0][rowL + r][colL + c] / maxIntensity;
                double G = (double)rgbMatirx[1][rowL + r][colL + c] / maxIntensity;
                double B = (double)rgbMatirx[2][rowL + r][colL + c] / maxIntensity;
                double maxRGB = this.getMaxRGB(R, G, B);
                double minRGB = this.getMinRGB(R, G, B);
                matrix[2][r][c] = maxRGB;
                double chroma = maxRGB - minRGB;
                matrix[1][r][c] = maxRGB == 0.0 ? 0.0 : chroma / maxRGB;
                matrix[0][r][c] = this.calculateHue(R, G, B, maxRGB, chroma);
            }
        }
        return matrix;
    }

    public double[][] RGB2HSV_Chroma(short[][][] rgbMatirx, double maxIntensity, int rowL, int rowH, int colL, int colH) {
        if (rowL < 0 || rowH >= rgbMatirx[0].length || rowL > rowH) {
            throw new RuntimeException("Row Subarray indices out of bounds");
        }
        if (colL < 0 || colH >= rgbMatirx[0][0].length || colL > colH) {
            throw new RuntimeException("Column Subarray indices out of bounds");
        }
        double[][] matrix = new double[rgbMatirx[0].length][rgbMatirx[0][0].length];
        int height = rowH - rowL;
        int width = colH - colL;
        for (int r = 0; r < height; ++r) {
            for (int c = 0; c < width; ++c) {
                double R = (double)rgbMatirx[0][rowL + r][colL + c] / maxIntensity;
                double G = (double)rgbMatirx[1][rowL + r][colL + c] / maxIntensity;
                double B = (double)rgbMatirx[2][rowL + r][colL + c] / maxIntensity;
                double maxRGB = this.getMaxRGB(R, G, B);
                double minRGB = this.getMinRGB(R, G, B);
                matrix[r][c] = maxRGB - minRGB;
            }
        }
        return matrix;
    }

    public double RGB2HSV_Value(short R, short G, short B, double maxIntensity) {
        double R_double = (double)R / maxIntensity;
        double G_double = (double)G / maxIntensity;
        double B_double = (double)B / maxIntensity;
        return this.getMaxRGB(R_double, G_double, B_double);
    }

    public double RGB2HSV_Hue(short R, short G, short B, double maxIntensity) {
        double R_double = (double)R / maxIntensity;
        double G_double = (double)G / maxIntensity;
        double B_double = (double)B / maxIntensity;
        double maxRGB = this.getMaxRGB(R_double, G_double, B_double);
        double minRGB = this.getMinRGB(R_double, G_double, B_double);
        double chroma = maxRGB - minRGB;
        return this.calculateHue(R_double, G_double, B_double, maxRGB, chroma);
    }

    public double RGB2HSV_Saturation(short R, short G, short B, double maxIntensity) {
        double R_double = (double)R / maxIntensity;
        double G_double = (double)G / maxIntensity;
        double B_double = (double)B / maxIntensity;
        double maxRGB = this.getMaxRGB(R_double, G_double, B_double);
        double minRGB = this.getMinRGB(R_double, G_double, B_double);
        double chroma = maxRGB - minRGB;
        if (maxRGB == 0.0) {
            return 0.0;
        }
        return chroma / maxRGB;
    }

    public double RGB2HSV_Chroma(short R, short G, short B, double maxIntensity) {
        double R_double = (double)R / maxIntensity;
        double G_double = (double)G / maxIntensity;
        double B_double = (double)B / maxIntensity;
        double maxRGB = this.getMaxRGB(R_double, G_double, B_double);
        double minRGB = this.getMinRGB(R_double, G_double, B_double);
        return maxRGB - minRGB;
    }

    private double calculateHue(double R, double G, double B, double maxRGB, double chroma) {
        if (chroma == 0.0) {
            return Double.NaN;
        }
        double h = maxRGB == R ? (G - B) / chroma % 6.0 : (maxRGB == G ? (B - R) / chroma + 2.0 : (R - G) / chroma + 4.0);
        return h * 60.0;
    }

    private double getMaxRGB(double R, double G, double B) {
        if (R >= G) {
            if (B >= R) {
                return B;
            }
            return R;
        }
        if (B >= G) {
            return B;
        }
        return G;
    }

    private double getMinRGB(double R, double G, double B) {
        if (R <= G) {
            if (B <= R) {
                return B;
            }
            return R;
        }
        if (B <= G) {
            return B;
        }
        return G;
    }
}

