/*
 * Decompiled with CFR 0.152.
 */
package aliImage;

import aliImage.AImageManipulation;
import aliImage.arrayCopyMethod;
import java.awt.Rectangle;
import std.StdStats;

public class AColorImage {
    short[][][] matrix = null;
    int depth = 0;
    private int numberOfComponents = 1;

    public AColorImage(int nComponents, int nRows, int nCols, int bitDepth) {
        this.matrix = new short[nComponents][nRows][nCols];
        this.numberOfComponents = nComponents;
        this.depth = bitDepth;
    }

    public AColorImage(AColorImage colorImage, Rectangle selectionArea) {
        this.numberOfComponents = colorImage.numberOfComponents;
        this.depth = colorImage.depth;
        this.matrix = new short[this.numberOfComponents][selectionArea.height][selectionArea.width];
        for (int ch = 0; ch < this.numberOfComponents; ++ch) {
            for (int row = 0; row < selectionArea.height; ++row) {
                for (int col = 0; col < selectionArea.width; ++col) {
                    this.matrix[ch][row][col] = colorImage.matrix[ch][row + selectionArea.y][col + selectionArea.x];
                }
            }
        }
    }

    public AColorImage(short[][][] mx, int bitDepth, arrayCopyMethod methodOfCopyArray) {
        this.depth = bitDepth;
        if (methodOfCopyArray == arrayCopyMethod.COPY_BY_REFRENCE) {
            this.matrix = mx;
        } else {
            this.matrix = new short[mx.length][mx[0].length][mx[0][0].length];
            for (int coef = 0; coef < mx.length; ++coef) {
                for (int r = 0; r < mx[0].length; ++r) {
                    System.arraycopy(mx[coef][r], 0, this.matrix[coef][r], 0, mx[0][0].length);
                }
            }
        }
        this.numberOfComponents = mx.length;
        this.depth = bitDepth;
    }

    public AColorImage convertToGray() {
        AColorImage grayImage = new AColorImage(1, this.getHeight(), this.getWidth(), this.depth);
        for (int row = 0; row < this.matrix[0].length; ++row) {
            for (int col = 0; col < this.matrix[0][0].length; ++col) {
                grayImage.matrix[0][row][col] = this.grayPixel(row, col);
            }
        }
        return grayImage;
    }

    public double window_filter(int channel, int row, int col, int radious, String type) {
        double[] array = new double[(2 * radious + 1) * (2 * radious + 1)];
        int i = 0;
        for (int r = row - radious; r <= row + radious; ++r) {
            for (int c = col - radious; c <= col + radious; ++c) {
                array[i] = this.matrix[channel][r][c];
                ++i;
            }
        }
        if ((type = type.toLowerCase()) == "mean") {
            return StdStats.mean(array);
        }
        if (type == "var") {
            return StdStats.var(array);
        }
        if (type == "max") {
            return StdStats.max(array);
        }
        if (type == "min") {
            return StdStats.min(array);
        }
        return Double.MAX_VALUE;
    }

    public double getMaxIntensity() {
        return Math.pow(2.0, this.depth);
    }

    public short[][][] getMatrix() {
        return this.matrix;
    }

    public int getWidth() {
        return this.matrix[0][0].length;
    }

    public int getHeight() {
        return this.matrix[0].length;
    }

    public int getNumberOfComponents() {
        return this.numberOfComponents;
    }

    public short[] getOnePixelComponents(int row, int col) {
        short[] components = new short[this.numberOfComponents];
        for (int i = 0; i < this.numberOfComponents; ++i) {
            components[i] = this.matrix[i][row][col];
        }
        return components;
    }

    public short get(int channel, int row, int col) {
        return this.matrix[channel][row][col];
    }

    public void setOnePixelComponents(int row, int col, short[] components) {
        if (components.length == this.numberOfComponents) {
            for (int i = 0; i < this.numberOfComponents; ++i) {
                this.matrix[i][row][col] = components[i];
            }
        }
    }

    public short grayPixel(int row, int col) {
        return (short)AImageManipulation.RGB2gray(this.matrix[0][row][col], this.matrix[1][row][col], this.matrix[2][row][col]);
    }

    public int[] grayHistogram() {
        int[] hist = new int[256];
        for (int row = 0; row < this.getHeight(); ++row) {
            for (int col = 0; col < this.getWidth(); ++col) {
                short s = this.grayPixel(row, col);
                hist[s] = hist[s] + 1;
            }
        }
        return hist;
    }

    public void DELETE_setMaxValue(short max) {
        for (int coef = 0; coef < this.matrix.length; ++coef) {
            for (int r = 0; r < this.matrix[0].length; ++r) {
                for (int c = 0; c < this.matrix[0][0].length; ++c) {
                    if (this.matrix[coef][r][c] <= max) continue;
                    this.matrix[coef][r][c] = max;
                }
            }
        }
    }

    public void filter2D(double[][] kernel, boolean doNormalization) {
        int col;
        int row;
        int nc;
        int uc = kernel.length / 2;
        int vc = kernel[0].length / 2;
        int height = this.matrix[0].length;
        int width = this.matrix[0][0].length;
        int normalizationFactor = 0;
        for (int i = 0; i < kernel.length; ++i) {
            for (int j = 0; j < kernel[0].length; ++j) {
                normalizationFactor = (int)((double)normalizationFactor + kernel[i][j]);
            }
        }
        short[][][] newMx = new short[this.numberOfComponents][height][width];
        double sum = 0.0;
        for (nc = 0; nc < this.numberOfComponents; ++nc) {
            for (row = vc; row < height - vc; ++row) {
                for (col = uc; col < width - uc; ++col) {
                    sum = 0.0;
                    for (int v = -vc; v <= vc; ++v) {
                        for (int u = -uc; u <= uc; ++u) {
                            sum += (double)this.matrix[nc][row + v][col + u] * kernel[v + vc][u + uc];
                        }
                    }
                    if (doNormalization) {
                        sum /= (double)normalizationFactor;
                    }
                    if (sum < 0.0) {
                        sum = 0.0;
                    }
                    if (sum > 255.0) {
                        sum = 255.0;
                    }
                    newMx[nc][row][col] = (short)sum;
                }
            }
        }
        for (nc = 0; nc < this.numberOfComponents; ++nc) {
            for (row = vc; row < height - vc; ++row) {
                for (col = uc; col < width - uc; ++col) {
                    this.matrix[nc][row][col] = newMx[nc][row][col];
                }
            }
        }
    }
}

