/*
 * Decompiled with CFR 0.152.
 */
package aliImage;

import aliImage.AColorImage;
import aliImage.AImageManipulation;
import aliImage.BinaryMode;
import aliImage.arrayCopyMethod;

public class ABinaryImage {
    boolean[][] matrix = null;
    private BinaryMode binaryMode = BinaryMode.BLACK_OBJECT_ON_WHITE_BACKGROUND;
    private boolean boolean_of_background = true;

    public ABinaryImage(int nRows, int nCols, BinaryMode binaryMode) {
        this.matrix = new boolean[nRows][nCols];
        this.binaryMode = binaryMode;
        this.boolean_of_background = binaryMode == BinaryMode.BLACK_OBJECT_ON_WHITE_BACKGROUND;
        for (int r = 0; r < nRows; ++r) {
            for (int c = 0; c < nCols; ++c) {
                this.matrix[r][c] = this.boolean_of_background;
            }
        }
    }

    public ABinaryImage(boolean[][] mx, arrayCopyMethod methodOfCopyArray, BinaryMode binaryMode) {
        if (methodOfCopyArray == arrayCopyMethod.COPY_BY_REFRENCE) {
            this.matrix = mx;
        } else {
            this.matrix = new boolean[mx.length][mx[0].length];
            for (int r = 0; r < mx[0].length; ++r) {
                System.arraycopy(mx[r], 0, this.matrix[r], 0, mx[0].length);
            }
        }
        this.binaryMode = binaryMode;
        this.boolean_of_background = binaryMode == BinaryMode.BLACK_OBJECT_ON_WHITE_BACKGROUND;
    }

    public ABinaryImage(AColorImage colorImage, int thresholod, BinaryMode binaryMode) {
        int height = colorImage.getHeight();
        int width = colorImage.getWidth();
        this.matrix = new boolean[height][width];
        this.binaryMode = binaryMode;
        this.boolean_of_background = binaryMode == BinaryMode.BLACK_OBJECT_ON_WHITE_BACKGROUND;
        for (int r = 0; r < height; ++r) {
            for (int c = 0; c < width; ++c) {
                if (AImageManipulation.RGB2gray(colorImage.matrix[0][r][c], colorImage.matrix[1][r][c], colorImage.matrix[2][r][c]) >= (double)thresholod) {
                    if (binaryMode == BinaryMode.BLACK_OBJECT_ON_WHITE_BACKGROUND) {
                        this.matrix[r][c] = this.boolean_of_background;
                        continue;
                    }
                    this.matrix[r][c] = !this.boolean_of_background;
                    continue;
                }
                this.matrix[r][c] = binaryMode == BinaryMode.BLACK_OBJECT_ON_WHITE_BACKGROUND ? !this.boolean_of_background : this.boolean_of_background;
            }
        }
    }

    boolean getXY(int x, int y) {
        return this.matrix[y][x];
    }

    public void setPixel(int row, int col, boolean value) {
        this.matrix[row][col] = value;
    }

    BinaryMode getBinaryMode() {
        return this.binaryMode;
    }

    boolean[][] getMatrix() {
        return this.matrix;
    }

    public boolean[][] getACopyOfMatrix() {
        boolean[][] copyMatrix = new boolean[this.matrix.length][this.matrix[0].length];
        for (int r = 0; r < this.matrix.length; ++r) {
            System.arraycopy(this.matrix[r], 0, copyMatrix[r], 0, this.matrix[0].length);
        }
        return copyMatrix;
    }

    public int getWidth() {
        return this.matrix[0].length;
    }

    public int getHeight() {
        return this.matrix.length;
    }

    public int[][] getIntegerCopyOfMatrix(int margin) {
        int[][] copyMatrix = new int[this.matrix.length + 2 * margin][this.matrix[0].length + 2 * margin];
        for (int row = 0; row < this.matrix.length; ++row) {
            for (int col = 0; col < this.matrix[0].length; ++col) {
                if (this.matrix[row][col] == this.boolean_of_background) continue;
                copyMatrix[row + margin][col + margin] = 1;
            }
        }
        return copyMatrix;
    }
}

