/*
 * Decompiled with CFR 0.152.
 */
package Moscegg.eggLibrary;

import Moscegg.eggLibrary.EggList;
import aliImage.PixelCoordinate;
import java.awt.Point;
import java.util.ArrayList;

public class MultipleEggSelection {
    ArrayList<Integer> arrayListSelectionIndex = new ArrayList();
    EggList egglist;
    int maximumValidDistance;

    public MultipleEggSelection(EggList egglist, int maximumValidDistance) {
        this.egglist = egglist;
        this.maximumValidDistance = maximumValidDistance;
    }

    public void addSelectdPoint(Point point) {
        int index = this.egglist.findNearestEggIndex(new PixelCoordinate(point), this.maximumValidDistance);
        if (index != -1 && !this.arrayListSelectionIndex.contains(new Integer(index))) {
            this.arrayListSelectionIndex.add(new Integer(index));
            this.egglist.getComponents((int)index).isSelected_for_UI = true;
        }
    }

    public void removeSelectdPoint(Point point) {
        int index = this.egglist.findNearestEggIndex(new PixelCoordinate(point), this.maximumValidDistance);
        if (index != -1) {
            this.arrayListSelectionIndex.remove(new Integer(index));
            this.egglist.getComponents((int)index).isSelected_for_UI = false;
        }
    }

    public void clearSelection() {
        for (int i = 0; i < this.arrayListSelectionIndex.size(); ++i) {
            Integer eggIndex = this.arrayListSelectionIndex.get(i);
            this.egglist.getComponents((int)eggIndex.intValue()).isSelected_for_UI = false;
        }
        this.arrayListSelectionIndex.clear();
    }

    public void undo() {
        if (!this.arrayListSelectionIndex.isEmpty()) {
            int lastEggIndex = this.arrayListSelectionIndex.get(this.arrayListSelectionIndex.size() - 1);
            this.egglist.getComponents((int)lastEggIndex).isSelected_for_UI = false;
            this.arrayListSelectionIndex.remove(new Integer(lastEggIndex));
        }
    }

    public void setSelectionValidity(boolean validity) {
        for (int i = 0; i < this.arrayListSelectionIndex.size(); ++i) {
            int eggIndex = this.arrayListSelectionIndex.get(i);
            if (validity) {
                this.egglist.makeValid_SpecificEgg(eggIndex);
            } else {
                this.egglist.makeInvalid_SpecificEgg(eggIndex);
            }
            this.egglist.getComponents((int)eggIndex).isSelected_for_UI = false;
        }
        this.arrayListSelectionIndex.clear();
    }

    public int size() {
        return this.arrayListSelectionIndex.size();
    }

    public int getNumberOfEggsInside_FirstItem() {
        if (this.arrayListSelectionIndex.size() > 0) {
            return this.egglist.calculateNumberOfEggInside(this.arrayListSelectionIndex.get(0));
        }
        return 0;
    }

    public void setNumberOfEggsInside_FirstItem(int NumberOfEggsInside) {
        this.egglist.getComponents(this.arrayListSelectionIndex.get(0)).setManuallyNumberOfEggInside(NumberOfEggsInside);
        this.egglist.getComponents(this.arrayListSelectionIndex.get(0)).setValidity(true);
        this.egglist.calculateNumberOfEggInside();
    }
}

