/*
 * Decompiled with CFR 0.152.
 */
package Moscegg.eggLibrary;

import Moscegg.eggLibrary.DELETE_CustomComparator_forConnectedComponent;
import Moscegg.eggLibrary.EggComponent;
import aliImage.ABinaryImage;
import aliImage.AConnectedComponents;
import aliImage.BinaryMode;
import aliImage.ConnectivityMode;
import aliImage.ContourExtractionType;
import aliImage.PixelCoordinate;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import std.StdStats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EggList
extends AConnectedComponents<EggComponent> {
    private boolean IS_LARVE_IMAGE;
    private long numberOfTotalEggInside;
    private int sizeOfOneEgg;

    public EggList(EggComponent sampleEgg, ABinaryImage binaryImage, BinaryMode binaryMode, ConnectivityMode connectivityMode, ContourExtractionType contourExtractionType, boolean IS_LARVE_IMAGE) {
        super(sampleEgg, binaryImage, binaryMode, connectivityMode, contourExtractionType);
        this.IS_LARVE_IMAGE = IS_LARVE_IMAGE;
        if (!IS_LARVE_IMAGE) {
            this.calculateSizeOfOneEgg();
            this.removeNoise_LessThanHalfSize(binaryImage, binaryMode);
        }
        this.calculateNumberOfEggInside();
    }

    public void addManuallyEgg(PixelCoordinate coordinate, int manuallyNumberOfEggInside) {
        ArrayList<PixelCoordinate> pixelCordinateslist = new ArrayList<PixelCoordinate>();
        pixelCordinateslist.add(coordinate);
        EggComponent newComp = new EggComponent(pixelCordinateslist);
        newComp.setManuallyNumberOfEggInside(manuallyNumberOfEggInside);
        this.components.add(newComp);
    }

    private void removeNoise_LessThanHalfSize(ABinaryImage binaryImage, BinaryMode binaryMode) {
        boolean foreground = true;
        if (binaryMode == BinaryMode.WHITE_OBJECT_ON_BLACK_BACKGROUND) {
            foreground = false;
        }
        for (int i = 0; i < this.components.size(); ++i) {
            PixelCoordinate[] cordinatesList;
            EggComponent egg = (EggComponent)this.components.get(i);
            if (egg.getSize() >= this.sizeOfOneEgg / 2) continue;
            for (PixelCoordinate cor : cordinatesList = egg.getPixels()) {
                binaryImage.setPixel(cor.y, cor.x, foreground);
            }
            this.components.remove(egg);
            --i;
        }
    }

    @Override
    public EggComponent getComponents(int i) {
        return (EggComponent)this.components.get(i);
    }

    public void calculateNumberOfEggInside() {
        this.numberOfTotalEggInside = 0L;
        for (int i = 0; i < this.components.size(); ++i) {
            this.numberOfTotalEggInside += (long)((EggComponent)this.components.get(i)).countEggsInside(this.sizeOfOneEgg, this.IS_LARVE_IMAGE);
        }
    }

    public int calculateNumberOfEggInside(int index) {
        return ((EggComponent)this.components.get(index)).countEggsInside(this.sizeOfOneEgg, this.IS_LARVE_IMAGE);
    }

    public long getNumberOfTotalEggInside() {
        return this.numberOfTotalEggInside;
    }

    public int findNearestEggIndex(PixelCoordinate selectedCoordinate) {
        return this.findNearestEggIndex(selectedCoordinate, Double.MAX_VALUE);
    }

    public int findNearestEggIndex(PixelCoordinate selectedCoordinate, double radious) {
        int minEggIndex = -1;
        if (!this.components.isEmpty()) {
            double mindist = Double.MAX_VALUE;
            for (int i = 0; i < this.components.size(); ++i) {
                double tempdist = ((EggComponent)this.components.get(i)).minimumdistance(selectedCoordinate);
                if (!(tempdist < mindist)) continue;
                mindist = tempdist;
                minEggIndex = i;
            }
            if (mindist < radious) {
                return minEggIndex;
            }
            return -1;
        }
        return -1;
    }

    public void makeValid_SpecificEgg(int eggIndex) {
        if (!((EggComponent)this.components.get(eggIndex)).getValidity()) {
            ((EggComponent)this.components.get(eggIndex)).setValidity(true);
            int numberOfEggsInside = ((EggComponent)this.components.get(eggIndex)).countEggsInside(this.sizeOfOneEgg, this.IS_LARVE_IMAGE);
            this.numberOfTotalEggInside += (long)numberOfEggsInside;
        }
    }

    public void makeInvalid_SpecificEgg(int eggIndex) {
        if (((EggComponent)this.components.get(eggIndex)).getValidity()) {
            int numberOfEggsInside = ((EggComponent)this.components.get(eggIndex)).countEggsInside(this.sizeOfOneEgg, this.IS_LARVE_IMAGE);
            ((EggComponent)this.components.get(eggIndex)).setValidity(false);
            this.numberOfTotalEggInside -= (long)numberOfEggsInside;
        }
    }

    public void makeValid(Rectangle rect) {
        for (int i = 0; i < this.components.size(); ++i) {
            if (((EggComponent)this.components.get(i)).getValidity() || !((EggComponent)this.components.get(i)).inside(rect)) continue;
            this.makeValid_SpecificEgg(i);
        }
    }

    public void makeInvalid(Rectangle rect) {
        for (int i = 0; i < this.components.size(); ++i) {
            if (!((EggComponent)this.components.get(i)).getValidity() || !((EggComponent)this.components.get(i)).inside(rect)) continue;
            this.makeInvalid_SpecificEgg(i);
        }
    }

    private int calculateMeanSize(ArrayList<EggComponent> comp) {
        int mean = 0;
        for (EggComponent egg : comp) {
            mean += egg.getSize();
        }
        return mean / comp.size();
    }

    private void DELETE_printArray(ArrayList<EggComponent> candidate, int estimated_size) {
        Collections.sort(candidate, new DELETE_CustomComparator_forConnectedComponent());
        DecimalFormat threePlaces = new DecimalFormat("0.00");
        System.out.println("======================================");
        for (EggComponent egg : candidate) {
            System.out.println("size: " + egg.getSize() + ", ecc: " + threePlaces.format(egg.eccentricity()) + ",cent_x: " + threePlaces.format(egg.centroid_X()) + ",cent_y: " + threePlaces.format(egg.centroid_Y()));
        }
        System.out.println("copunt: " + candidate.size());
        System.out.println("size: " + estimated_size);
    }

    public void SetSizeOfOneEgg_Manually(int sizeOfOneEgg) {
        this.sizeOfOneEgg = sizeOfOneEgg;
    }

    public int sizeOfOneEgg() {
        return this.sizeOfOneEgg;
    }

    public void calculateSizeOfOneEgg() {
        int firstIdea;
        ArrayList<EggComponent> candidate = new ArrayList<EggComponent>();
        for (EggComponent egg : this.components) {
            double ecc = egg.eccentricity();
            if (!egg.getValidity() || !(ecc > 0.95) || !(ecc < 0.99)) continue;
            candidate.add(egg);
        }
        int[] candidateEggsSize = new int[candidate.size()];
        for (int i = 0; i < candidate.size(); ++i) {
            candidateEggsSize[i] = ((EggComponent)candidate.get(i)).getSize();
        }
        this.sizeOfOneEgg = firstIdea = StdStats.mode(candidateEggsSize);
    }
}

