/*
 * Decompiled with CFR 0.152.
 */
package Moscegg.eggLibrary;

import aliImage.ConnectedComponent;
import aliImage.EuclideanDistance;
import aliImage.PixelCoordinate;
import java.awt.Rectangle;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EggComponent
extends ConnectedComponent {
    private static double PARAMETER_MAX_LARVE_ECCENTRICIY = 0.85;
    private int manuallyNumberOfEggInside = 0;
    private boolean isValidEgg = true;
    public boolean isSelected_for_UI = false;
    private static double PARAMETER_SetsOfEggCorrectionRatio = 0.7;

    public EggComponent(ArrayList<PixelCoordinate> pixelCordinateslist) {
        super(pixelCordinateslist);
    }

    public void setValidity(boolean validity) {
        this.isValidEgg = validity;
        if (!validity) {
            this.manuallyNumberOfEggInside = 0;
        }
    }

    public boolean getValidity() {
        return this.isValidEgg;
    }

    public int getValidSize() {
        if (this.isValidEgg) {
            return this.getSize();
        }
        return 0;
    }

    public PixelCoordinate[] getPixels() {
        return this.pixelCoordinates;
    }

    @Override
    public EggComponent newInstance(ArrayList<PixelCoordinate> pixelCordinateslist) {
        EggComponent e = new EggComponent(pixelCordinateslist);
        return e;
    }

    public double minimumdistance(PixelCoordinate coordinate) {
        return EuclideanDistance.minimumDistance(coordinate, this.pixelCoordinates);
    }

    private int countEggsInside_IS_LARVE_IMAGE() {
        if (this.manuallyNumberOfEggInside > 0) {
            return this.manuallyNumberOfEggInside;
        }
        if (this.isValidEgg) {
            return 1;
        }
        return 0;
    }

    public boolean lessThanEccentricity_LARVE() {
        double eccent = this.eccentricity();
        return eccent <= PARAMETER_MAX_LARVE_ECCENTRICIY && eccent > 0.0;
    }

    public int countEggsInside(double sizeOfOneEgg, boolean IS_LARVE_IMAGE) {
        if (IS_LARVE_IMAGE) {
            return this.countEggsInside_IS_LARVE_IMAGE();
        }
        if (this.manuallyNumberOfEggInside > 0) {
            return this.manuallyNumberOfEggInside;
        }
        if (this.isValidEgg && sizeOfOneEgg != 0.0) {
            if ((double)this.pixelCoordinates.length > 2.0 * sizeOfOneEgg) {
                return (int)Math.round(PARAMETER_SetsOfEggCorrectionRatio * (double)this.pixelCoordinates.length / sizeOfOneEgg);
            }
            return (int)Math.round((double)this.pixelCoordinates.length / sizeOfOneEgg);
        }
        return 0;
    }

    public void setManuallyNumberOfEggInside(int manuallyNumberOfEggInside) {
        this.manuallyNumberOfEggInside = manuallyNumberOfEggInside;
    }

    public boolean inside(Rectangle rect) {
        if (rect != null && this.pixelCoordinates != null) {
            boolean isInside = true;
            for (PixelCoordinate cor : this.pixelCoordinates) {
                if (rect.contains(cor)) continue;
                isInside = false;
                break;
            }
            return isInside;
        }
        return false;
    }
}

