/*
 * Decompiled with CFR 0.152.
 */
package Moscegg.eggLibrary;

import aliImage.ABinaryImage;
import aliImage.AColorImage;
import aliImage.BinaryMode;
import aliImage.Thresholding;

public class AuthomaticEggImageThresholding {
    public int YenThreshold(AColorImage colorImage, int maxValue) {
        int[] histogram = colorImage.grayHistogram();
        for (int i = maxValue; i < histogram.length; ++i) {
            int n = maxValue - 1;
            histogram[n] = histogram[n] + histogram[i];
            histogram[i] = 0;
        }
        return Thresholding.Yen(histogram);
    }

    public ABinaryImage Sauvola(AColorImage grayImage, int radius, double par1, double par2, BinaryMode binaryMode) {
        if (grayImage.getNumberOfComponents() != 1) {
            System.out.println("Function thresholding needs gray image.");
            return null;
        }
        ABinaryImage binaryResult = new ABinaryImage(grayImage.getHeight(), grayImage.getWidth(), binaryMode);
        double k_value = 0.5;
        double r_value = 128.0;
        if (par1 != 0.0) {
            k_value = par1;
        }
        if (par2 != 0.0) {
            r_value = par2;
        }
        boolean boolean_of_background = binaryMode == BinaryMode.BLACK_OBJECT_ON_WHITE_BACKGROUND;
        for (int row = radius; row < grayImage.getHeight() - radius; ++row) {
            for (int col = radius; col < grayImage.getWidth() - radius; ++col) {
                double mean = grayImage.window_filter(0, row, col, radius, "mean");
                double var = grayImage.window_filter(0, row, col, radius, "var");
                boolean pixel = (grayImage.get(0, row, col) & 0xFF) > (int)(mean * (1.0 + k_value * (Math.sqrt(var) / r_value - 1.0))) ? boolean_of_background : !boolean_of_background;
                binaryResult.setPixel(row, col, pixel);
            }
        }
        return binaryResult;
    }
}

