/*
 * Decompiled with CFR 0.152.
 */
package Moscegg;

import Moscegg.ImagePanel;
import Moscegg.MosceggView;
import Moscegg.ProgressShowFrame;
import Moscegg.eggLibrary.AuthomaticEggImageThresholding;
import Moscegg.eggLibrary.EggComponent;
import Moscegg.eggLibrary.EggList;
import Moscegg.eggLibrary.ShitDetector;
import aliImage.ABinaryImage;
import aliImage.AColorImage;
import aliImage.AImageIO;
import aliImage.BinaryMode;
import aliImage.ConnectivityMode;
import aliImage.ContourExtractionType;
import java.awt.Image;

public class OpenEggImageThread
implements Runnable {
    private MosceggView mainFrame;
    private ProgressShowFrame progressFrame;
    private boolean IS_LARVE_IMAGE;
    private int PARAMNETER_MOST_LIGHT;
    private AColorImage colorImage;
    private int minimumPossibleThreshold;
    private double shitChromaThreshold;
    private boolean perforAutoExcerement;

    public OpenEggImageThread(MosceggView mainFrame, ProgressShowFrame progressFrame, boolean IS_LARVE_IMAGE, int PARAMNETER_MOST_LIGHT, AColorImage colorImage, int minimumPossibleThreshold, double shitChromaThreshold, boolean perforAutoExcerement) {
        this.mainFrame = mainFrame;
        this.progressFrame = progressFrame;
        this.IS_LARVE_IMAGE = IS_LARVE_IMAGE;
        this.PARAMNETER_MOST_LIGHT = PARAMNETER_MOST_LIGHT;
        this.colorImage = colorImage;
        this.minimumPossibleThreshold = minimumPossibleThreshold;
        this.shitChromaThreshold = shitChromaThreshold;
        this.perforAutoExcerement = perforAutoExcerement;
    }

    public void run() {
        this.progressFrame.setProgMax(5);
        this.progressFrame.setVisible(true);
        this.progressFrame.setAlwaysOnTop(true);
        boolean defualtZoomSize = true;
        double defaultZoomPercentage_in_eachZoonInOut = 1.0;
        Image image = AImageIO.convertJavaImage(this.colorImage);
        ImagePanel m_imagePanel = new ImagePanel(image, (double)defualtZoomSize, defaultZoomPercentage_in_eachZoonInOut, this.IS_LARVE_IMAGE);
        this.progressFrame.setProgValue(2);
        this.progressFrame.setProgMessage("Processing automatic egg detection");
        AuthomaticEggImageThresholding thresholding = new AuthomaticEggImageThresholding();
        int AutoThresholdYEN = thresholding.YenThreshold(this.colorImage, this.PARAMNETER_MOST_LIGHT);
        if (AutoThresholdYEN > 100 + this.minimumPossibleThreshold) {
            AutoThresholdYEN = 100 + this.minimumPossibleThreshold;
        }
        ABinaryImage binaryImage = new ABinaryImage(this.colorImage, AutoThresholdYEN, BinaryMode.BLACK_OBJECT_ON_WHITE_BACKGROUND);
        this.progressFrame.setProgValue(3);
        this.progressFrame.setProgMessage("Extracting Eggs from the image");
        EggComponent egg = new EggComponent(null);
        EggList eggList = new EggList(egg, binaryImage, BinaryMode.BLACK_OBJECT_ON_WHITE_BACKGROUND, ConnectivityMode.EIGHT_NEIGHBOR_CONNECTIVITY, ContourExtractionType.EXTRACT_JUST_OUTER_CONTOUR, this.IS_LARVE_IMAGE);
        m_imagePanel.setBinaryImage(AImageIO.convertJavaImage(binaryImage));
        if (this.perforAutoExcerement) {
            ShitDetector shitDetector = new ShitDetector();
            if (!this.IS_LARVE_IMAGE) {
                this.progressFrame.setProgValue(4);
                this.progressFrame.setProgMessage("Detecting non-egg particles");
                shitDetector.detecShits_simpleIdeaByChromaThresold(this.colorImage, eggList, this.shitChromaThreshold, 5.0);
            } else {
                shitDetector.set_LARVE_invalidObjects_byEccentricity(eggList);
            }
        }
        this.progressFrame.setProgValue(5);
        this.progressFrame.setProgMessage("Finalizing");
        m_imagePanel.setEggList(eggList);
        this.mainFrame.FinishingOpenImage(this.colorImage, m_imagePanel, binaryImage, AutoThresholdYEN);
        this.progressFrame.dispose();
    }
}

