/*
 * Decompiled with CFR 0.152.
 */
package Moscegg;

import Moscegg.GraphicManger;
import Moscegg.What2Display;
import Moscegg.eggLibrary.EggComponent;
import Moscegg.eggLibrary.EggList;
import Moscegg.eggLibrary.MultipleEggSelection;
import aliImage.PixelCoordinate;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    private boolean display_valid_eggs = true;
    private boolean display_invalid_eggs = true;
    private boolean IS_LARVE_IMAGE;
    private int PARAMETER_FOR_UI_SIZE_OF_FONT = 12;
    private int PARAMETER_FOR_UI_SIZE_OF_FONT_FOR_FINAL_RESULT_TEXT = 20;
    private int PARAMETER_FOR_MOUSE_SELECTION_DISTANCE_RADIOUS = 10;
    private MultipleEggSelection multipleEggSelection;
    private int offset = 0;
    private What2Display what2Display;
    private double m_zoom = 1.0;
    private double m_zoomPercentage;
    private Image imageColor;
    private GraphicManger graphicManager;
    private EggList eggList;
    private boolean hasValidEggList;
    private Image imageBinary;
    private Rectangle selectionArea;
    public Point selectedPointForManuallyMarking;
    private Ellipse2D.Double circle = new Ellipse2D.Double(10.0, 10.0, 350.0, 350.0);

    public ImagePanel(Image image, double defualtZoomSize, double zoomPercentage, boolean IS_LARVE_IMAGE) {
        this.imageColor = image;
        this.m_zoomPercentage = zoomPercentage / 100.0;
        this.m_zoom = defualtZoomSize;
        this.hasValidEggList = false;
        this.graphicManager = new GraphicManger(this.offset, this.offset);
        this.what2Display = What2Display.JUSTColorImage;
        this.IS_LARVE_IMAGE = IS_LARVE_IMAGE;
    }

    public ImagePanel(Image imageColor, Image imageBinary, double defualtZoomSize, double zoomPercentage, boolean IS_LARVE_IMAGE) {
        this.imageColor = imageColor;
        this.imageBinary = imageBinary;
        this.m_zoomPercentage = zoomPercentage / 100.0;
        this.m_zoom = defualtZoomSize;
        this.hasValidEggList = false;
        this.graphicManager = new GraphicManger(this.offset, this.offset);
        this.what2Display = What2Display.JUSTBinaryImage;
        this.IS_LARVE_IMAGE = IS_LARVE_IMAGE;
    }

    public ImagePanel(Image imageColor, Image imageBinary, EggList eggList, double defualtZoomSize, double zoomPercentage, boolean IS_LARVE_IMAGE) {
        this.imageColor = imageColor;
        this.imageBinary = imageBinary;
        this.m_zoomPercentage = zoomPercentage / 100.0;
        this.m_zoom = defualtZoomSize;
        this.graphicManager = new GraphicManger(this.offset, this.offset);
        this.what2Display = What2Display.ColorImage_InsideCount;
        this.eggList = eggList;
        this.hasValidEggList = true;
        this.IS_LARVE_IMAGE = IS_LARVE_IMAGE;
    }

    public void setDisplay_Valid_Eggs(boolean display_valid_eggs) {
        this.display_valid_eggs = display_valid_eggs;
        this.repaint();
    }

    public void setDisplay_Invalid_Eggs(boolean display_invalid_eggs) {
        this.display_invalid_eggs = display_invalid_eggs;
        this.repaint();
    }

    public int getNumberOfEggsInside_FirstItemMultipleEggSelection() {
        if (this.multipleEggSelection != null) {
            return this.multipleEggSelection.getNumberOfEggsInside_FirstItem();
        }
        return 0;
    }

    public void setNumberOfEggsInside_FirstItemMultipleEggSelection(int NumberOfEggsInside) {
        this.multipleEggSelection.setNumberOfEggsInside_FirstItem(NumberOfEggsInside);
    }

    public void setNumberOfEggsManuallyMarked(int NumberOfEggsInside) {
        this.ModifyPointCoordinate(this.selectedPointForManuallyMarking);
        if (this.selectedPointForManuallyMarking != null) {
            PixelCoordinate center = new PixelCoordinate(this.selectedPointForManuallyMarking);
            this.eggList.addManuallyEgg(center, NumberOfEggsInside);
            this.selectedPointForManuallyMarking = null;
            this.eggList.calculateNumberOfEggInside();
        }
    }

    public void clearMultipleEggSelection() {
        if (this.multipleEggSelection != null) {
            this.multipleEggSelection.clearSelection();
            this.repaint();
        }
    }

    private void ModifyPointCoordinate(Point selectedPoint) {
        selectedPoint.x = (int)((double)selectedPoint.x / this.m_zoom);
        selectedPoint.y = (int)((double)selectedPoint.y / this.m_zoom);
    }

    public void addPoint2MultipleEggSelection(Point p) {
        if (this.multipleEggSelection != null) {
            this.ModifyPointCoordinate(p);
            this.multipleEggSelection.addSelectdPoint(p);
            this.repaint();
        }
    }

    public int getMultipleEggSelected_count() {
        if (this.multipleEggSelection != null) {
            return this.multipleEggSelection.size();
        }
        return 0;
    }

    public void undoMultipleEggSelection() {
        if (this.multipleEggSelection != null) {
            this.multipleEggSelection.undo();
            this.repaint();
        }
    }

    public void setMultiSelectionValidity(boolean validity) {
        if (this.multipleEggSelection != null) {
            this.multipleEggSelection.setSelectionValidity(validity);
        }
    }

    public void setSelectionArea(Rectangle selectionArea) {
        this.selectionArea = selectionArea;
        this.repaint();
    }

    public void clearSlectionArea() {
        this.selectionArea = null;
        this.repaint();
    }

    public long getNumberOfTotalEggsInside() {
        if (this.eggList != null) {
            return this.eggList.getNumberOfTotalEggInside();
        }
        return 0L;
    }

    public long getNumberSizeOfOneEgg() {
        if (this.eggList != null) {
            return this.eggList.sizeOfOneEgg();
        }
        return 0L;
    }

    public void setEggInvalid(int clicked_X, int clicked_Y) {
        PixelCoordinate coordinate;
        int minEggIndex;
        if (this.hasValidEggList && (minEggIndex = this.eggList.findNearestEggIndex(coordinate = new PixelCoordinate((int)((double)clicked_Y / this.m_zoom), (int)((double)clicked_X / this.m_zoom)), this.PARAMETER_FOR_MOUSE_SELECTION_DISTANCE_RADIOUS)) >= 0) {
            this.eggList.makeInvalid_SpecificEgg(minEggIndex);
            this.repaint();
        }
    }

    public void setEggsInvalid(Rectangle rect) {
        if (this.hasValidEggList) {
            this.eggList.makeInvalid(rect);
        }
    }

    public void setEggsValid(Rectangle rect) {
        if (this.hasValidEggList) {
            this.eggList.makeValid(rect);
        }
    }

    public void setEggList(EggList eggList) {
        if (eggList != null) {
            this.eggList = eggList;
            this.hasValidEggList = true;
            this.what2Display = What2Display.ColorImage_InsideCount;
            this.multipleEggSelection = new MultipleEggSelection(eggList, this.PARAMETER_FOR_MOUSE_SELECTION_DISTANCE_RADIOUS);
        } else {
            this.hasValidEggList = false;
        }
    }

    public EggList getEggList() {
        if (this.hasValidEggList && this.eggList != null) {
            return this.eggList;
        }
        return null;
    }

    public void clearEggList() {
        this.eggList.makeEmpty();
        this.what2Display = What2Display.JUSTColorImage;
    }

    public void paintComponent(Graphics grp) {
        Graphics2D g2D = (Graphics2D)grp;
        g2D.setColor(Color.WHITE);
        g2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2D.scale(this.m_zoom, this.m_zoom);
        switch (this.what2Display) {
            case JUSTColorImage: {
                g2D.drawImage(this.imageColor, 0, 0, this);
                break;
            }
            case JUSTBinaryImage: {
                g2D.drawImage(this.imageBinary, 0, 0, this);
                break;
            }
            case ColorImage_InsideCount: {
                g2D.drawImage(this.imageColor, 0, 0, this);
                this.writeSizeBesideConComponents(g2D);
                break;
            }
            case BinaryImage_InsideCount: {
                g2D.drawImage(this.imageBinary, 0, 0, this);
                this.writeSizeBesideConComponents(g2D);
            }
        }
        if (this.selectionArea != null) {
            g2D.setColor(Color.blue);
            g2D.draw(this.selectionArea);
        }
        g2D.dispose();
    }

    public void WriteCurrentTofile(String fileFullNamePath, String fileExtention) throws IOException {
        if (this.imageColor != null) {
            int w = this.imageColor.getWidth(this);
            int h = this.imageColor.getHeight(this);
            BufferedImage bufferedImage = new BufferedImage(w, h, 1);
            Graphics2D g2D = bufferedImage.createGraphics();
            g2D.drawImage(this.imageColor, 0, 0, this);
            this.writeSizeBesideConComponents(g2D);
            g2D.setPaint(Color.RED);
            g2D.setFont(new Font(this.getFont().getName(), 1, this.PARAMETER_FOR_UI_SIZE_OF_FONT_FOR_FINAL_RESULT_TEXT));
            if (this.IS_LARVE_IMAGE) {
                g2D.drawString("Total number of Larves: " + Long.toString(this.getNumberOfTotalEggsInside()), 10, this.PARAMETER_FOR_UI_SIZE_OF_FONT_FOR_FINAL_RESULT_TEXT + 10);
            } else {
                g2D.drawString("Total number of eggs: " + Long.toString(this.getNumberOfTotalEggsInside()), 10, this.PARAMETER_FOR_UI_SIZE_OF_FONT_FOR_FINAL_RESULT_TEXT + 10);
            }
            g2D.drawString("Egg-Counter 1.0", 10, 10 + this.PARAMETER_FOR_UI_SIZE_OF_FONT_FOR_FINAL_RESULT_TEXT + this.PARAMETER_FOR_UI_SIZE_OF_FONT_FOR_FINAL_RESULT_TEXT + 5);
            g2D.dispose();
            if (fileExtention.toLowerCase().trim().equals("jpg")) {
                Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("jpg");
                ImageWriter imageWriter = writers.next();
                ImageWriteParam iwp = imageWriter.getDefaultWriteParam();
                iwp.setCompressionMode(2);
                float[] values = iwp.getCompressionQualityValues();
                iwp.setCompressionQuality(values[values.length - 1]);
                ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(new FileOutputStream(fileFullNamePath));
                imageWriter.setOutput(imageOutputStream);
                imageWriter.write(null, new IIOImage(bufferedImage, null, null), iwp);
                imageOutputStream.close();
                imageWriter.dispose();
            } else {
                ImageIO.write((RenderedImage)bufferedImage, fileExtention, new File(fileFullNamePath));
            }
        }
    }

    private void writeSizeBesideConComponents(Graphics2D g2D) {
        if (this.hasValidEggList) {
            g2D.setFont(new Font(this.getFont().getName(), 1, this.PARAMETER_FOR_UI_SIZE_OF_FONT));
            int SizeOfOneEgg = this.eggList.sizeOfOneEgg();
            int size = this.eggList.size();
            for (int i = 0; i < size; ++i) {
                EggComponent temp = this.eggList.getComponents(i);
                this.graphicManager.writeSizeBesideConComponent(g2D, temp, SizeOfOneEgg, this.IS_LARVE_IMAGE, this.display_valid_eggs, this.display_invalid_eggs);
            }
        }
    }

    public void wrtireString(Graphics2D g2D) {
        g2D.setPaint(Color.black);
    }

    protected Ellipse2D.Double getCircle() {
        return this.circle;
    }

    private void drawCircle(Graphics2D g2D) {
        g2D.setPaint(Color.blue);
        g2D.setStroke(new BasicStroke(8.0f));
        g2D.draw(this.getCircle());
    }

    public Dimension getPreferredSize() {
        return new Dimension((int)((double)this.imageColor.getWidth(this) + (double)this.imageColor.getWidth(this) * (this.m_zoom - 1.0)), (int)((double)this.imageColor.getHeight(this) + (double)this.imageColor.getHeight(this) * (this.m_zoom - 1.0)));
    }

    public void setZoomPercentage(int zoomPercentage) {
        this.m_zoomPercentage = (double)zoomPercentage / 100.0;
    }

    public void originalSize() {
        this.m_zoom = 1.0;
    }

    public void zoomIn() {
        this.m_zoom += this.m_zoomPercentage;
    }

    public void zoomOut() {
        this.m_zoom -= this.m_zoomPercentage;
        if (this.m_zoom < this.m_zoomPercentage) {
            if (this.m_zoomPercentage > 1.0) {
                this.m_zoom = 1.0;
            } else {
                this.zoomIn();
            }
        }
    }

    public double getZoomSize() {
        return this.m_zoom;
    }

    public void setWhat2Display(What2Display displayMode) {
        this.what2Display = displayMode;
    }

    public What2Display getWhat2Display() {
        return this.what2Display;
    }

    public void setBinaryImage(Image imageBinary) {
        this.imageBinary = imageBinary;
    }
}

