/*
 * Decompiled with CFR 0.152.
 */
package Moscegg;

import Moscegg.ImagePanel;
import Moscegg.MosceggView;
import Moscegg.ProgressShowFrame;
import Moscegg.eggLibrary.EggComponent;
import Moscegg.eggLibrary.EggList;
import Moscegg.eggLibrary.ShitDetector;
import aliImage.ABinaryImage;
import aliImage.AColorImage;
import aliImage.AImageIO;
import aliImage.BinaryMode;
import aliImage.ConnectivityMode;
import aliImage.ContourExtractionType;

public class ChangeThresholdSensitivityThread
implements Runnable {
    private MosceggView mainFrame;
    private ProgressShowFrame progressFrame;
    private AColorImage colorImage;
    private int thresholdValue;
    private ImagePanel m_imagePanel;
    private boolean IS_LARVE_IMAGE;
    private double shitChromaThreshold;
    private boolean perforAutoExcerement;

    public ChangeThresholdSensitivityThread(MosceggView mainFrame, ProgressShowFrame progressFrame, AColorImage colorImage, int thresholdValue, ImagePanel m_imagePanel, boolean IS_LARVE_IMAGE, double shitChromaThreshold, boolean perforAutoExcerement) {
        this.mainFrame = mainFrame;
        this.progressFrame = progressFrame;
        this.colorImage = colorImage;
        this.thresholdValue = thresholdValue;
        this.m_imagePanel = m_imagePanel;
        this.IS_LARVE_IMAGE = IS_LARVE_IMAGE;
        this.shitChromaThreshold = shitChromaThreshold;
        this.perforAutoExcerement = perforAutoExcerement;
    }

    public void run() {
        this.progressFrame.setProgMax(4);
        this.progressFrame.setVisible(true);
        this.progressFrame.setAlwaysOnTop(true);
        ABinaryImage binaryImage = new ABinaryImage(this.colorImage, this.thresholdValue, BinaryMode.BLACK_OBJECT_ON_WHITE_BACKGROUND);
        this.progressFrame.setProgValue(1);
        this.progressFrame.setProgMessage("Extracting Eggs from the image");
        EggComponent egg = new EggComponent(null);
        EggList eggList = new EggList(egg, binaryImage, BinaryMode.BLACK_OBJECT_ON_WHITE_BACKGROUND, ConnectivityMode.EIGHT_NEIGHBOR_CONNECTIVITY, ContourExtractionType.EXTRACT_JUST_OUTER_CONTOUR, this.IS_LARVE_IMAGE);
        this.m_imagePanel.setBinaryImage(AImageIO.convertJavaImage(binaryImage));
        if (this.perforAutoExcerement) {
            ShitDetector shitDetector = new ShitDetector();
            if (!this.IS_LARVE_IMAGE) {
                this.progressFrame.setProgValue(2);
                this.progressFrame.setProgMessage("Detecting non-egg particles");
                shitDetector.detecShits_simpleIdeaByChromaThresold(this.colorImage, eggList, this.shitChromaThreshold, 5.0);
            } else {
                shitDetector.set_LARVE_invalidObjects_byEccentricity(eggList);
            }
        }
        this.progressFrame.setProgValue(3);
        this.progressFrame.setProgMessage("Finalizing");
        this.m_imagePanel.setEggList(eggList);
        this.mainFrame.FinishingThresholdSensitivity(this.m_imagePanel, binaryImage);
        this.progressFrame.dispose();
    }
}

